<?php

namespace Mtc\VehicleValuation\Contracts;

use Carbon\Carbon;
use Illuminate\Contracts\Support\Arrayable;

class ValuationResponse implements Arrayable
{
    public function __construct(
        private readonly string $provider,
        private readonly string $registration,
        private readonly int $mileage,
        private readonly string $vehicleType,
        private readonly ?float $retailPrice,
        private readonly ?float $averagePrice = null,
        private readonly ?float $cleanPrice = null,
        private readonly ?float $belowPrice = null,
        private readonly ?string $make = null,
        private readonly ?string $model = null,
        private readonly ?string $derivative = null,
        private readonly ?string $fuelType = null,
        private readonly int|string|null $engineSize = null,
        private readonly ?string $bodyType = null,
        private readonly ?string $dateOfValuation = null,
        private readonly ?string $transmission = null,
        private readonly ?string $registrationDate = null,
        private readonly ?string $colour = null,
        private readonly ?array $errors = null,
        private readonly ?string $valuation_id = null,
        private readonly ?array $data = null,
        private readonly ?string $cosmetic_condition = null,
    ) {
        //
    }

    public function toArray(): array
    {
        return [
            'provider' => $this->provider,
            'registration' => $this->registration,
            'mileage' => $this->mileage,
            'vehicle_type' => $this->vehicleType,
            'make' => $this->make,
            'model' => $this->model,
            'derivative' => $this->derivative,
            'fuel_type' => $this->fuelType,
            'engine_size' => $this->engineSize,
            'body_type' => $this->bodyType,
            'transmission' => $this->transmission,
            'date_of_registration' => $this->registrationDate,
            'valuation_made_at' => $this->dateOfValuation,
            'retail_price' => $this->retailPrice,
            'average_price' => $this->averagePrice,
            'clean_price' => $this->cleanPrice,
            'below_price' => $this->belowPrice,
            'colour' => $this->colour,
            'errors' => $this->errors,
            'valuation_id' => $this->valuation_id,
            'data' => $this->data,
            'cosmetic_condition' => $this->cosmetic_condition,
        ];
    }
}
