<?php

namespace Mtc\VehicleSavings\Listeners;

use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Mtc\ContentManager\Facades\Fields;
use Mtc\MercuryDataModels\Events\LoadVehicleDataFields;
use Mtc\VehicleSavings\VehicleSavingsHelper;

class AddSavingsToVehicleFields
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param object $event
     * @return Collection
     */
    public function handle(LoadVehicleDataFields $event)
    {
        $values = VehicleSavingsHelper::getEnabledCalculator()->getSavings($event->vehicle);

        return $event->type === 'admin'
            ? $values
                ->map(fn($value, $key) => [
                    'slug' => $key,
                    'name' => __("savings::labels.$key"),
                    'component' => 'EditableContent' . Fields::field('number')->getComponent(),
                    'value' => [
                        [
                            'id' => Str::random(),
                            'value' => $value,
                        ]
                    ],
                ])->values()
            : $values;
    }
}
