<?php

namespace Mtc\VehicleReservations;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Mtc\Checkout\Invoice;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\Money\HasPrices;

class ReservationStatus extends Model
{
    use HasPrices;

    /**
     * Mass assignable variables
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'is_final',
        'is_initial',
        'is_editable',
    ];

    /**
     * Cast variables to specific types
     *
     * @var array
     */
    protected $casts = [
        'is_final' => 'boolean',
        'is_initial' => 'boolean',
        'is_editable' => 'boolean',
    ];
}
