<?php

namespace Mtc\VehicleReservations\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReservationRequest extends FormRequest
{
    public function rules()
    {
        return [
            'name' => [
                'required_without:first_name,last_name',
                'string',
                'max:255',
            ],
            'first_name' => [
                'required_without:name',
                'string',
                'max:255',
            ],
            'last_name' => [
                'required_without:name',
                'string',
                'max:255',
            ],
            'email' => [
                'nullable',
                'email',
                'max:255',
            ],
        ];
    }
}
