<?php

namespace Mtc\VehicleReservations\Http\Controllers;

use App\Facades\Settings;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\VehicleReservations\Http\Requests\ReservationRequest;
use Mtc\VehicleReservations\Reservation;
use Mtc\VehicleReservations\ReservationRepository;

class ReservationFlowController
{
    public function create(ReservationRequest $request, Vehicle $vehicle, ReservationRepository $repository)
    {
        $data = $request->input();
        $data['vehicle_id'] = $vehicle->id;
        /** @var Reservation $reservation */
        $reservation = $repository->create($data);
        $invoice_repository = $repository->createInvoice($reservation);
        $reservation['config'] = [
            'invoice_id' => $invoice_repository->getId(),
            'amount' => $invoice_repository->getOutstandingAmount() * 100,
            'country' => Settings::get('app-details-country'),
            'currency' => $invoice_repository->getCurrency(),
            'item_name' => 'Reservation fee for ' . $invoice_repository->getModel()->items->pluck('name')->implode(','),
            'stripe_public_key' => App::make(config('stripe.config'))->publicKey(),
            'customer' => null,
        ];
        return $reservation;
    }

    public function update(
        ReservationRequest $request,
        Reservation $reservation,
        ReservationRepository $repository
    ): Reservation {
        return $repository->updateDetails($reservation, $request->input());
    }
}
