<?php

namespace Mtc\VehicleReservations\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\VehicleReservations\Jobs\ProcessIncomingReservationJob;
use Mtc\VehicleReservations\Reservation;

class IngestReservations extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reservations:ingest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process new incoming reservations';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Reservation::query()
            ->with('vehicle')
            ->where('attempts', '<', 5)
            ->whereNotNull('confirmed_at')
            ->whereNull('ingested_at')
            ->get()
            ->each(fn(Reservation $reservation) => $this->dispatch(new ProcessIncomingReservationJob($reservation)));

        return 0;
    }
}
