<?php

namespace Mtc\VehicleLookup\Drivers;

use App\Modules\Lookup\Contracts\VehicleLookupData;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\VehicleLookup\Contracts\VehicleLookupDriver;
use Mtc\VehicleLookup\VehicleLookupResponse;

class EVA extends \Mtc\VehicleValuation\EVA implements VehicleLookupDriver
{
    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse
    {
        return $this->parseResponse($registration_number, $mileage, $this->getVehicleData($registration_number));
    }

    private function parseResponse(string $registration_number, $mileage, array $vehicle): VehicleLookupResponse
    {
        return new VehicleLookupResponse(
            $registration_number,
            $mileage,
            make: $vehicle['Make'],
            model: $vehicle['Model'],
            derivative: $vehicle['Derivative'],
            colour: $vehicle['ExteriorColour'],
            body_type: $vehicle['BodyStyle'],
            fuel_type: $vehicle['Fuel'],
            transmission: $vehicle['Transmission'],
            registration_date: $vehicle['DateOfFirstRegistration'],
            engine_capacity_cc: $vehicle['EngineCapacity'],
            body_style: $vehicle['BodyStyle'],
            vin: $vehicle['VINSerialNumber'],
            doors: $vehicle['NoOfDoors'],
        );
    }

    public function findDerivatives(VehicleMake $make, VehicleModel $model): array
    {
        return [];
    }

    public function findVariants(VehicleMake $make, VehicleModel $model, string $derivative = ''): array
    {
        return [];
    }

    public function getTechnicalData(string $variant): VehicleLookupData
    {
        return new VehicleLookupData();
    }
}
