<?php

namespace Mtc\VehicleLookup\Config;


class MotorCheckConfig
{
    public function __construct()
    {
    }

    public function clientId(): string
    {
        return config('lookup.drivers.motor-check.client_id', '');
    }

    public function clientSecret(): string
    {
        return config('lookup.drivers.motor-check.client_secret', '');
    }

    public function country(): string
    {
        return strtolower(config('lookup.drivers.motor-check.country') ?? 'gb');
    }

    public function toArray(): array
    {
        return [
            'username' => $this->clientId(),
            'password' => $this->clientSecret(),
            'country' => $this->country(),
            'live' => app()->environment('production')
        ];
    }
}
