<?php

return [
    /*
    |--------------------------------------------------------------------------
    |  Drivers
    |--------------------------------------------------------------------------
    |
    | Drivers that provide valuation functionality
    |
    */
    'drivers' => [
        'cap' => [
            'config' => \Mtc\VehicleLookup\Config\CapConfig::class,
            'subscriber_id' => env('CAP_SUBSCRIBER_ID'),
            'password' => env('CAP_PASSWORD'),
        ],
        'beep-beep' => [
            'config' => \Mtc\VehicleLookup\Config\BeepBeepConfig::class,
            'api_key' => env('BEEP_BEEP_API_KEY'),
        ],
        'auto-trader' => [
            'config' => \Mtc\VehicleLookup\Config\AutoTraderConfig::class,
            'api_key' => env('AUTO_TRADER_LOOKUP_API_KEY'),
            'api_secret' => env('AUTO_TRADER_LOOKUP_API_SECRET'),
            'merchant_id' => env('AUTO_TRADER_API_MERCHANT_ID'),
            'live' => env('AUTO_TRADER_USE_LIVE_API', true),
        ],
        'at-connect' => [
            'config' => \Mtc\VehicleLookup\Config\AutoTraderConfig::class,
            'api_key' => env('AUTO_TRADER_LOOKUP_API_KEY'),
            'api_secret' => env('AUTO_TRADER_LOOKUP_API_SECRET'),
            'merchant_id' => env('AUTO_TRADER_API_MERCHANT_ID'),
            'live' => env('AUTO_TRADER_USE_LIVE_API', true),
        ],
        'bca' => [
            'config' => \Mtc\VehicleLookup\Config\BCAConfig::class,
            'api_key' => env('BCA_API_KEY'),
            'api_secret' => env('BCA_API_SECRET'),
            'live' => env('BCA_LIVE_API', true),
        ],
        'motor-check' => [
            'config' => \Mtc\VehicleLookup\Config\MotorCheckConfig::class,
            'client_id' => env('MOTOR_CHECK_CLIENT_ID'),
            'client_secret' => env('MOTOR_CHECK_CLIENT_SECRET'),
            'country' => env('MOTOR_CHECK_COUNTRY'),
        ],
        'eva' => [
            'config' => \Mtc\VehicleLookup\Config\EVAConfig::class,
        ],
    ],
];
