<?php

namespace Mtc\Taxonomies\Seeds;

use Illuminate\Database\Seeder;
use Mtc\Core\Admin\Menu;
use Mtc\Core\Admin\Permission;

/**
 * Class TaxonomySeeder
 *
 * @package Mtc\Taxonomies\Seeds
 */
class TaxonomySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (Menu::query()->where('permission_name','taxonomies')->count() > 0) {
            return;
        }

        $parent = Menu::query()->where('permission_name', 'mtc-only')->first();
        Menu::query()
            ->create([
                'title' => 'Taxonomies',
                'sub_id' => $parent->id ?? 0,
                'path' => '/admin/taxonomies',
                'activePath' => 'admin/taxonomies',
                'constant' => '',
            ]);


        /** @var Permission $permission */
        $permission = Permission::query()
            ->updateOrCreate([
                'name' => 'delete-taxonomy-sections',
            ],[
                'name' => 'delete-taxonomy-sections',
                'guard_name' => 'web',
                'group' => 'MTC Only',
                'model_group' => 'admin',
            ]);

        $permission->assignRole('mtc');
    }
}
