<?php

use Illuminate\Routing\Router;
use Mtc\Taxonomies\Http\Controllers\TaxonomyController;

$router->group([
    'prefix' => '/admin',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {
    $router->post('taxonomies/add-child', [TaxonomyController::class, 'addChild']);
    $router->post('taxonomies/re-order', [TaxonomyController::class, 'reorder'])->name('taxonomies.reorder');
    $router->post('taxonomies/change-parent', [TaxonomyController::class, 'changeParent']);
    $router->post('taxonomies/list', [TaxonomyController::class, 'showList']);
    $router->post('taxonomies/{taxonomy}/toggle-active', [TaxonomyController::class, 'toggleActive'])->name('taxonomies.toggle-active');
    $router->resource('taxonomies', TaxonomyController::class)->except([ 'show' ]);
    $router->get('taxonomies/{slug}', [TaxonomyController::class, 'show'])->name('taxonomies.show');

});
