<?php

namespace Mtc\Taxonomies\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

/**
 * Class TaxonomyServiceProvider
 *
 * @package Mtc\Taxonomies
 */
class TaxonomyServiceProvider extends ServiceProvider
{
    /**
     * Register this package
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/taxonomies.php', 'taxonomies');
    }

    /**
     * Start (boot) this service
     */
    public function boot()
    {
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'taxonomies');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/taxonomies.php' => config_path('taxonomies.php'),
            ], 'config');

            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            // Publishing the translation files.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/taxonomies'),
            ], 'lang');
        }
    }
}
