<?php

namespace Mtc\Taxonomies\Traits;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Kalnoy\Nestedset\AncestorsRelation;
use Mtc\Taxonomies\Scopes\RootLevelTaxonomyIsScope;

trait IsSubTaxonomy
{
    public static function bootIsSubTaxonomy()
    {
        self::addGlobalScope(new RootLevelTaxonomyIsScope((new self())->root_taxonomy_slug));
    }

    public function ancestors()
    {
        $taxonomy_model = App::make(Config::get('taxonomies.taxonomy_model'));
        return new AncestorsRelation($taxonomy_model->newQuery(), $taxonomy_model);
    }
}
