<?php

namespace Mtc\Taxonomies\Traits;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Mtc\Taxonomies\Scopes\IsFirstLevelTaxonomyScope;

trait IsFirstLevelTaxonomy
{
    public static function bootIsFirstLevelTaxonomy()
    {
        self::addGlobalScope(new IsFirstLevelTaxonomyScope((new self())->root_taxonomy_slug));
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(Config::get('taxonomies.taxonomy_model'), $this->getParentIdName())
            ->setModel($this);
    }
}
