<?php

namespace Mtc\Taxonomies\Seeds;

use Illuminate\Database\Seeder;
use Mtc\Admin\Models\Menu;

/**
 * Class TaxonomySeeder
 *
 * @package Mtc\Taxonomies\Seeds
 */
class TaxonomySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (Menu::query()->where('permission_name', 'taxonomies')->count() > 0) {
            return;
        }

        $main_menu = Menu::query()
            ->create([
                'title' => 'Taxonomies',
                'icon' => 'far fa-database'
            ]);

        $main_menu->children()
            ->create([
                'title' => 'Manage Taxonomies',
                'path' => '/taxonomies',
                'active_path' => '/taxonomies',
            ]);
    }
}
