<?php

namespace Mtc\Taxonomies\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class IsFirstLevelTaxonomyScope implements Scope
{
    public function __construct(protected string $root_level_taxonomy_slug)
    {
        //
    }

    /**
     * @param Builder $builder
     * @param Model $model
     */
    public function apply(Builder $builder, Model $model)
    {
        return $builder->whereHas('parent', function ($query) {
            $query->whereNull('parent_id');
        });
    }
}
