<?php

namespace Mtc\Taxonomies\Providers;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Mtc\Taxonomies\Console\Commands\MakeTaxonomyCommand;
use Mtc\Taxonomies\Contracts\TaxonomyModel;
use Mtc\Taxonomies\Seeds\TaxonomySeeder;

/**
 * Class TaxonomyServiceProvider
 *
 * @package Mtc\Taxonomies
 */
class TaxonomyServiceProvider extends EventServiceProvider
{
    /**
     * Register this package
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/taxonomies.php', 'taxonomies');
        parent::register();
    }

    /**
     * Start (boot) this service
     */
    public function boot()
    {
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'taxonomies');
        $this->loadViewsFrom(dirname(__DIR__, 2) . '/resources/views', 'taxonomies');

        $this->app->bind(TaxonomyModel::class, Config::get('taxonomies.taxonomy_model'));
        $this->app->bind('taxonomies', Config::get('taxonomies.repository_class'));

        Relation::morphMap([
            'taxonomy' => Config::get('taxonomies.taxonomy_model')
        ]);

        if ($this->app->runningInConsole()) {
            $this->commands([
                MakeTaxonomyCommand::class
            ]);

            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            // Publishing the translation files.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/taxonomies'),
            ], 'lang');
        }


        Event::listen('additional-database-seeds', function ($seeder) {
            $seeder->call(TaxonomySeeder::class);
        });
    }

    /**
     * Register events
     *
     * @return array
     */
    public function listens(): array
    {
        return Config::get('taxonomies.events', []);
    }
}
