<?php

namespace Mtc\Taxonomies\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Mtc\Taxonomies\Contracts\TaxonomyModel;
use Mtc\Taxonomies\Models\Taxonomy;

class TaxonomyImport implements WithHeadingRow, ToModel
{
    use Importable;

    protected Collection $import_map;
    protected TaxonomyModel|null $parent;
    protected string $name_column;
    protected int $active;

    public function setMap(array $import_map): self
    {
        $this->import_map = collect($import_map)->filter();
        $this->name_column = $this->import_map->search('name');
        $this->import_map->forget($this->name_column);
        return $this;
    }

    public function setActive(int $active): self
    {
        $this->active = $active;
        return $this;
    }

    public function setParentModelId($parent_model_id): self
    {
        $this->parent = Taxonomy::query()->find($parent_model_id);
        return $this;
    }

    public function model(array $row)
    {
        $taxonomy = $this->parent->children()
            ->create([
                'name' => $row[$this->name_column],
                'active' => $this->active,
            ]);

        $this->saveCustomFields($taxonomy, $row);
    }

    protected function saveCustomFields(TaxonomyModel $taxonomy, array $row)
    {
        if ($this->import_map->isEmpty()) {
            return;
        }

        unset($row[$this->name_column]);
        $taxonomy->saveCustomFields($this->mapCustomFields($row));
    }

    protected function mapCustomFields(array $row)
    {
        return collect($row)
            ->filter(fn($value, $data_column) => !empty($value) && $this->import_map->search($data_column))
            ->keyBy(fn($value, $data_column) => $this->import_map->search($data_column))
            ->toArray();
    }
}
