<?php

namespace Mtc\Taxonomies\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class TaxonomyList
 *
 * @package Mtc\Taxonomies
 */
class TaxonomyList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        $root = $this->resource->getRoot();
        $this->resource->children
            ->map(function ($child) use ($root) {
                $child->loadCustomFields($root->customFieldGroup->id ?? null);
                $child->is_open = false;
                $child->edit = false;
                return $child;
            });
        $this->resource->tree_structure = $root->tree_structure;
        return parent::toArray($request);
    }
}
