<?php

namespace Mtc\Taxonomies\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;
use Mtc\Breadcrumbs\Facades\Breadcrumbs;
use Mtc\Taxonomies\Facades\Taxonomies;
use Mtc\Taxonomies\Contracts\TaxonomyModel;

/**
 * Class TaxonomyController
 *
 * @package Mtc\Taxonomies\Http\Controllers\
 */
class ExportTaxonomyController
{
    use ValidatesRequests;

    public function export(TaxonomyModel $taxonomy_model, $taxonomy)
    {
        $taxonomy_model = $taxonomy_model->findFromSlug($taxonomy);
        Breadcrumbs::addCrumb(__('taxonomies::taxonomies.manage_taxonomies'), route('taxonomies.index'));
        Breadcrumbs::addCrumb($taxonomy_model->name, route('taxonomies.show', $taxonomy));
        Breadcrumbs::addCrumb('Export ' . Str::plural($taxonomy_model->name), route('taxonomies.export', $taxonomy));
        return view('taxonomies::export', [
            'taxonomy' => $taxonomy_model,
        ]);
    }

    public function showExport(TaxonomyModel $taxonomy_model, $taxonomy)
    {
        $taxonomy = $taxonomy_model->findFromSlug($taxonomy);
        return [
            'taxonomy_columns' => Taxonomies::exportableColumns($taxonomy),
            'export_formats' => Config::get('taxonomies.export_formats'),
        ];
    }

    public function runExport(Request $request, TaxonomyModel $taxonomy_model, $taxonomy)
    {
        $taxonomy = $taxonomy_model->findFromSlug($taxonomy);
        $this->validate($request, [
            'format' => [
                'required',
                Rule::in(['csv', 'xlsx'])
            ],
            'columns' => [
                'required',
                'array'
            ]
        ]);

        $export = App::make(Config::get('taxonomies.export_class'))
            ->setRequest($request)
            ->setModel($taxonomy);

        $file_name = $export->getFileName();
        Excel::store($export, $file_name);

        return response()->download(Storage::disk('local')->path($file_name));
    }
}
