<?php

namespace Mtc\Taxonomies\Facades;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Mtc\Taxonomies\Contracts\TaxonomyModel;
use Mtc\Taxonomies\TaxonomyRepository;

/**
 * @method static TaxonomyModel create(string $name, string $slug, array $options = [])
 * @method static void insert(TaxonomyModel $parent, array $list_of_records)
 * @method static bool exists(string $slug)
 * @method static Builder ancestorQuery(int $ancestor_id)
 * @method static Collection exportableColumns(TaxonomyModel $taxonomy)
 * @see TaxonomyRepository
 */
class Taxonomies extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'taxonomies';
    }
}
