<?php

namespace Mtc\Taxonomies\Exports;

use Illuminate\Contracts\Support\Responsable;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Mtc\Taxonomies\Contracts\TaxonomyModel;
use Mtc\Taxonomies\Facades\Taxonomies;

class TaxonomyExport implements FromCollection, WithHeadings, WithMapping, Responsable, ShouldAutoSize
{
    use Exportable;

    protected $taxonomy;

    protected $request;

    protected $exportable_columns;

    public function setModel(TaxonomyModel $taxonomy)
    {
        $this->taxonomy = $taxonomy;
        $this->getFileName();
        return $this;
    }

    public function setRequest(Request $request)
    {
        $this->request = $request;
        return $this;
    }
    /**
     * Get file name based on request date from and date to
     */
    public function getFileName()
    {
        return $this->fileName = $this->taxonomy->slug . '_export_' . time() . '.' . $this->extension();
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return $this->taxonomy->descendants;
    }

    public function headings(): array
    {
        $this->exportable_columns = Taxonomies::exportableColumns($this->taxonomy)->pluck('name', 'id');

        return $this->exportable_columns
            ->filter(function ($column_name, $id) {
                return in_array($id, $this->request->input('columns'));
            })
            ->toArray();
    }

    public function map($row): array
    {
        return $this->exportable_columns
            ->filter(function ($column_name, $id) {
                return in_array($id, $this->request->input('columns'));
            })
            ->map(function ($column_name, $id) use ($row) {
                return $row->getAttribute($id);
            })
            ->toArray();
    }

    protected function extension()
    {
        return $this->request->input('format');
    }
}
