<?php

use Illuminate\Routing\Router;
use Mtc\Taxonomies\Http\Controllers\TaxonomyController;
/** @var Router $router */
$router->group([
    'prefix' => config('admin.route_prefix'),
    'middleware' => [
        'auth'
    ]
], function (Router $router) {
    $router->get('taxonomies/{slug}/export/show', [config('taxonomies.controllers.export'), 'showExport'])->name('taxonomies.export.show');
    $router->post('taxonomies/{slug}/export', [config('taxonomies.controllers.export'), 'runExport'])->name('taxonomies.export.run');
    $router->get('taxonomies/{slug}/export', [config('taxonomies.controllers.export'), 'export'])->name('taxonomies.export');

    $router->put('taxonomies/{slug}/import', [config('taxonomies.controllers.import'), 'runImport'])->name('taxonomies.import.run');
    $router->post('taxonomies/{slug}/import', [config('taxonomies.controllers.import'), 'uploadAndReview'])->name('taxonomies.import.step-2');
    $router->get('taxonomies/{slug}/import', [config('taxonomies.controllers.import'), 'import'])->name('taxonomies.import');

    $router->post('taxonomies/bulk-delete', [TaxonomyController::class, 'bulkDelete'])->name('taxonomies.bulk-delete');
    $router->post('taxonomies/add-child', [TaxonomyController::class, 'addChild'])->name('taxonomies.add-child');
    $router->post('taxonomies/re-order', [TaxonomyController::class, 'reorder'])->name('taxonomies.reorder');
    $router->post('taxonomies/change-parent', [TaxonomyController::class, 'changeParent'])->name('taxonomies.change-parent');
    $router->post('taxonomies/list', [TaxonomyController::class, 'showList'])->name('taxonomies.show-list');
    $router->post('taxonomies/{taxonomy}/toggle-active', [TaxonomyController::class, 'toggleActive'])->name('taxonomies.toggle-active');
    $router->resource('taxonomies', TaxonomyController::class)->except([ 'show' ]);
    $router->get('taxonomies/{slug}', [TaxonomyController::class, 'show'])->name('taxonomies.show');

});
