<h3>Details</h3>
<form action="{{ $taxonomy->exists ? route('taxonomies.update', [ $taxonomy ]) : route('taxonomies.store') }}"
        method="post"
        class="mb-0">

    <div class="shadow">

        <div class="bg-white p-4">
            <x-form::text name="name"
                    :value="$taxonomy->name">
                Name
            </x-form::text>

            <x-form::checkbox name="active"
                    field-value="1"
                    :value="$taxonomy->active">
                Active
            </x-form::checkbox>

            <x-form::checkbox name="tree_structure"
                    field-value="1"
                    :value="$taxonomy->tree_structure">
                {{ __('taxonomies::taxonomies.is_tree_structure') }}
            </x-form::checkbox>
        </div>

        <div class="px-4 py-3">
            <button type="submit"
                    class="btn btn-primary">
                Save
            </button>
            @if ($taxonomy->exists == false)
                <button type="submit"
                    name="action"
                    value="continue_edit"
                        class="btn btn-outline-primary">
                    Save and set up fields
                </button>
            @else
                <a href="{{ route('taxonomies.show', $taxonomy->slug) }}"
                    class="btn btn-outline-secondary">
                    View Taxonomy
                </a>
            @endif

            @method($taxonomy->exists ? 'PUT' : 'POST')
            @csrf
        </div>
    </div>
</form>
