@extends('admin::layouts.admin.list')

@section('title', 'Manage Taxonomies')

@section('primary-action')

    <a href="{{ route('taxonomies.create') }}" class="btn btn-danger">
        <i class="fas fa-plus-circle"></i> Add Taxonomy
    </a>
@endsection

@section('table_head')
    <th>Name</th>
    <th>List</th>
    <th></th>
@endsection

@section('table_body')

    @foreach($taxonomies as $taxonomy)
        <tr>
            <td class="orderStatus align-middle">
                <a href="{{ route('taxonomies.edit', [ $taxonomy->id ]) }}" class="text-body">
                    {{ $taxonomy->name }}
                </a>
                <small class="pl-2 text-muted">ID: {{ $taxonomy->id }}, slug: {{ $taxonomy->slug }}</small>
            </td>
            <td>

                <a href="{{ route('taxonomies.show', [ $taxonomy->slug ]) }}" class="text-body font-weight-bold">
                    View entries
                </a>
            </td>
            <td class="text-right">
                <i class="fas {{ $taxonomy->active ? 'fa-eye' : 'fa-eye-slash' }}"
                    title="{{ $taxonomy->active ? 'Active' : 'Inactive' }}"></i>

                <a href="{{ route('taxonomies.edit', [ $taxonomy ]) }}" class="ml-4">
                    <i class="fas fa-pencil"></i>
                </a>

                <a class="notify-item text-danger ml-4 mr-3"
                    onclick="event.preventDefault(); document.getElementById('delete-record-{{ $taxonomy->id }}').submit();">
                    <i class="fas fa-trash"></i>
                </a>

                <form id="delete-record-{{ $taxonomy->id }}"
                    action="{{ route('taxonomies.destroy', $taxonomy) }}" method="POST" class="d-none">
                    @csrf
                    @method('DELETE')
                </form>

            </td>
        </tr>

    @endforeach

@endsection
