<?php

namespace Mtc\Stripe\Contracts;

use Illuminate\Http\Request;
use Mtc\Basket\Contracts\BasketRepositoryInterface;

/**
 * Interface StripePaymentRequestBasketFillInterface
 *
 * @package Mtc\Stripe
 */
interface AbstractStripeConfig
{
    public function privateKey(): string;

    public function publicKey(): string;

    public function applicableCheckClass(): string;

    public function externalPaymentsApplicableCheckClass(): string;

    public function paymentGatewayClass(): string;

    public function minimalTransactionAmount(): string;

    public function additionalPaymentGateways(): bool;

    public function basketFillFactory(): string;

    public function confirmationStatus(): string;

    public function cardStorage(): bool;
}
