# Stripe Payments

This package provides payment processing through [Stripe](https://stripe.com/).
This package is intended to be used with **[mtcmedia/shop](https://bitbucket.org/mtcmedia/shop/)** or 
**[mtcmedia/checkout](https://bitbucket.org/mtcmedia/packages-checkout/)** and will likely not work without them.

Stripe Documentation can be found [here](https://stripe.com/docs)

## Installation and setup
```bash
composer require mtcmedia/stripe-payments
```
After composer has installed run the following command that will publish
`stripe.js` and `stripe_payment.vue` to `/resources/js/vendor/app/` 
```bash
php artisan install:components
```

By default stripe will use mtc test account keys therefore no setup required
on development environment.

### Production Server Setup

1. **Onboarding**: The client will need to be onboarded to our Stripe account. This
   can be done by visiting https://pay.mtc.co.uk/onboarding/stripe and entering their
   company name. This will provide you with a URL you can send to the customer to
   onboard themselves by either creating a new account, or connecting to ours.
2. **Credentials**: Ask Craig for Restricted Key, Publishable Key, and Stripe Account
   for this Company. These should be stored under production's `.env` under
   `STRIPE_PUBLIC_KEY`, `STRIPE_PRIVATE_KEY`, and `STRIPE_ACCOUNT_ID`.

## Update Existing Install

You may need to re-publish some assets between versions here, as recent changes have
changed config and JS files.

This can be re-published via ``php artisan vendor:publish --provider="Mtc\Stripe\Providers\StripeServiceProvider"``.
You may need to add `--force` to trigger a re-write. When doing this, make sure any
previous custom settings are not overwritten.

Remember after updating you will need to re-run npm for changes to assets to take effect.

If the `Stripe.php` or `StripePaymentRequest.php` files have been overwritten in your
install, you may need to review the changes manually to ensure they're copied over.

## Configuration

Stripe package provides following configuration values (managed through `config/stripe.php`)

* `applicable_check_class` - set custom workflow for checking whether stripe can be used for taking payments with cards
* `external_payments_applicable_check_class`  - set custom workflow for checking whether stripe can be used for taking payments with ApplePay/GooglePay
* `payment_gateway_class` - extend/modify the payment processor class
* `minimal_transaction_amount` - set a custom minimal transactio amount. Stripe does set 0.30 as their minimal limit, so must be higher than that
* `additional_payment_gateways` - enable ApplePay/GooglePay
* `basket_fill_factory` - customize how ApplePay/GooglePay data populate customer details
* `confirmation_status` - what to set as the order confirmation status when payment is confirmed
* `card_storage` - enable card storage for re-use on next purchases

## Payment Workflow

Stripe implements PaymentGateway, HasDeferredCharges and HandlesRefunds functionalities.

`PaymentGateway` ensures that Payments can be taken by the gateway. Stripe has slightly amended workflow to the default 
flow (`charge()` method) as it requires the verification/PSD-2/SCA flow. This is done via StripeController.

Normal payment workflow uses card payments via form that shows up on checkout page payment section.
There is an alternate quick-checkout option using ApplePay/GooglePay using PaymentRequest feature. This is disabled by default, 
however can be easily enabled via `additional_payment_gateways` config. ApplePay also will require [these actions](https://stripe.com/docs/apple-pay/web/v2).

Stripe window creates a secure way of processing card details without requiring us to perform PCI-DSS compliance.
This is achieved via Stripe Elements that create fields via JS. Stripe processes these fields and return a token to us.
We then attempt to charge invoice amount on this token. If successful we mark invoice as paid and return success state for 
proceeding to success page. Alternatively a challenge might be required - we return to UI and trigger the challenge
(or confirmation / verification) window. Once client verifies the transaction the Stripe controller is invoked once again
to check and confirm payment has taken place. 
In case of failure user is not charged and order is considered failed.

`HasDeferredCharges` allows implementation of deferred (delayed) charges.
This uses the pattern of authenticating a transaction now and capturing it at a later stage.
When a deferred payment is registered the payment is added to invoice, but it is not marked as confirmed (no timestamp).
Payment then can be captured from viewing the invoice/payment in admin UI.

`HandlesRefunds` allows implementation of refunds. This requires [mtcmedia/refunds](https://bitbucket.org/mtcmedia/refunds/src/master/) 
to be present in the project. Stripe has 30 day refund period for transactions, past this term refunds no longer will be available.
Refund is managed from admin UI for invoice/payment - there will be a form against payment to select a refundable amount 
and submit refund (Stripe does allow multiple partial refunds per transaction).
 
 ## Changelog
 See [Changelog](CHANGELOG.md)

## Contributing
Please see [Contributing](CONTRIBUTING.md) for details.
