<?php

namespace Mtc\Stripe\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Stripe\Providers\StripeServiceProvider;

/**
 * Class InstallCheckout
 *
 * @package Mtc\ShippingManager
 */
class InstallStripe extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'stripe:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Stripe Payment Gateway assets';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Stripe');

        $this->callSilent('vendor:publish', [
            '--provider' => StripeServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->info('Stripe installed successfully.');
    }
}
