<?php

namespace Mtc\SquarePay\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\Basket\Events\AddExternalPaymentGatewayScripts;
use Mtc\Basket\Events\LoadExternalPaymentGateways;
use Mtc\Basket\Http\Resources\CheckoutAjax;
use Mtc\Checkout\Events\AddPaymentGatewayScripts;
use Mtc\SquarePay\Listeners\AddSquareExternalButton;
use Mtc\SquarePay\Listeners\AddSquarePayExternalScripts;
use Mtc\SquarePay\SquareExternal;

/**
 * Class BankTransferServiceProvider
 *
 * @package Mtc\BankTransfer
 */
class SquarePayServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        if (config('square.enabled', false) === false) {
            return;
        }

        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'square');
        $this->app['payment']->extend('clearpay', function($app) {
            $gateway = config('square.gateway_class');
            return new $gateway();
        });

        if (!$this->app->runningInConsole()) {
            Event::listen(AddPaymentGatewayScripts::class, AddSquarePayExternalScripts::class);
        } else {
            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');
        }

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');

    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/square.php', 'square');
    }
}