<?php

namespace Mtc\SiteNavigation\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class TaxonomyList
 *
 * @package Mtc\SiteNavigation
 */
class MenuList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource->children
            ->map(function ($child) {
                $child->has_button = !empty($child->button_text) || !empty($child->button_link);
                $child->is_open = false;
                $child->edit = false;
                return $child;
            });
        return parent::toArray($request);
    }
}
