<?php


use Illuminate\Routing\Router;
use Mtc\SiteNavigation\Http\Controllers\NavigationController;
/** @var Router $router */

$router->group([
    'prefix' => '/admin',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {
    $router->post('navigation/add-child', [NavigationController::class, 'addChild']);
    $router->post('navigation/re-order', [NavigationController::class, 'reorder']);
    $router->post('navigation/change-parent', [NavigationController::class, 'changeParent']);
    $router->post('navigation/list', [NavigationController::class, 'showList']);
    $router->post('navigation/{menu}/toggle-active', [NavigationController::class, 'toggleActive'])->name('navigation.toggle-active');
    $router->resource('navigation', NavigationController::class)->except([ 'show' ]);
    $router->get('navigation/{menu}', [NavigationController::class, 'show'])->name('navigation.show');

});
