<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateSiteNavigationables
 */
class CreateSiteNavigationTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_navigation', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->index();
            $table->string('slug')->unique();
            $table->boolean('published')->index();
            $table->nestedSet();
            $table->string('target')->default('self');
            $table->string('url')->nullable();
            $table->string('css_class')->nullable();
            $table->string('sub_entry_type')->nullable();
            $table->integer('sub_entries')->nullable();

            $table->string('title')->nullable();
            $table->string('description')->nullable();
            $table->string('button_text')->nullable();
            $table->string('button_link')->nullable();
            $table->timestamps();

        });

        Schema::create('site_navigation_images', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('navigation_id')->unsigned()->index();
            $table->string('url');
            $table->mediumInteger('order')->unsigned();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_navigation');
        Schema::dropIfExists('site_navigation_images');
    }
}
