<?php

namespace MtcMedia\SimpleView;

class SimpleView
{
    protected $templatePath;

    protected $globals = [];

    public function __construct($templatePath)
    {
        $this->templatePath = $templatePath;
    }

    public function addGlobal($name, $value)
    {
        if (isset($this->globals[$name])) {
            throw new \RuntimeException("Global variable [$name] already defined");
        }
        $this->globals[$name] = $value;
    }

    public function addGlobals($variables)
    {
        foreach ($variables as $name => $value) {
            $this->addGlobal($name, $value);
        }
    }

    public function getGlobal($name)
    {
        return isset($this->globals[$name]) ? $this->globals[$name] : null;
    }

    /**
     * @return array
     */
    public function getGlobals()
    {
        return $this->globals;
    }



    public function render($template, $_viewData = [])
    {
        global $member, $p, $page, $path, $adminuser;

        $template = $this->fullPath($template);

        set_include_path($this->templatePath);

        // extract globals first
        extract($this->globals);
        // then local variables
        extract($_viewData);

        ob_start();
        require $template;
        $rendered = ob_get_clean();

        restore_include_path();
        return $rendered;
    }

    public function fullPath($template)
    {
        if (!starts_with($template, '/')) {
            $template = $this->templatePath . "/" . str_replace(['/', '.'], ['', '/'], $template) . ".phtml";
        }
        return $template;
    }

    public function amount($amount, $currency = '£')
    {
        return $currency . number_format($amount, 2);
    }

    /**
     * Render a delete button enclosed inside a form
     * @param $href
     * @param $what
     * @return mixed
     */
    public function deleteForm($href, $what)
    {
        return $this->render(SITE_PATH . '/core/admin/templates/delete.button-form.phtml', compact('href', 'what'));
    }
}
