<?php

namespace Mtc\Ecommerce\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Basket\Providers\BasketServiceProvider;

/**
 * Class InstallBasket
 *
 * @package Mtc\ShippingManager
 */
class InstallShop extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:shop';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Basket default assets/data';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Foundation');
        $this->callSilent('install:foundation');

        $this->info('Installing Basket');
        $this->callSilent('install:basket');

        $this->info('Installing Checkout');
        $this->callSilent('install:checkout');

        $this->info('Installing Order Management');
        $this->callSilent('install:orders');

        $this->info('Installing Shipping Manager');
        $this->callSilent('install:shipping');

        $this->info('Installing Coupons');
        $this->callSilent('install:coupons');
    }
}
