# Shop

This package provides list of features that are required to ensure shop functionality for mtc ecommerce platform.

Package itself does not provide any functionality itself, but it focues around collating key features and adding them to 
the system in one run.

Currently this system does have following features as part of this package:

* ecommerce [**basket**](https://bitbucket.org/mtcmedia/packages-basket/) to build a basket with items and set details on items
* [**checkout**](https://bitbucket.org/mtcmedia/packages-checkout/) scaffolding for instantiating payment on a basket/order
* [**order management**](https://bitbucket.org/mtcmedia/packages-order-management/) for viewing/processing orders placed on site
* [**members area**](https://bitbucket.org/mtcmedia/members/) for customer accounts and customers being able to view their past purchases
* [**members basket**](https://bitbucket.org/mtcmedia/members-basket/) for linking customer details to basket automatically 
* [**sales tracking**](https://bitbucket.org/mtcmedia/sales-tracking/) for reporting sales to google analytics/gtm
* [**shipping manager**](https://bitbucket.org/mtcmedia/packages-shipping-manager/) for setting up delivery costs (region based) and also support courier label integration
* [**coupons**](https://bitbucket.org/mtcmedia/packages-coupons/) for code based discounts on basket
* [**taxonomies**](https://bitbucket.org/mtcmedia/taxonomies/) for creating custom data objects (property lists) for shop products in custom field use
* [**PayPal payments**](https://bitbucket.org/mtcmedia/paypal-payments/) for taking payments with PayPal. Supports card payments using PPCP solution. 

## Installation
This tool is meant to be used with mtcmedia/platform and shop usually should be set up as part of new site install process.  

```shell
composer require mtcmedia/shop

php artisan install:components
```

## Additional features
This package does provide minimal set of features for mtc ecommerce, however this is not the full list of available features.

Following optional mtcmedia packages exist that support the ecommerce system:

* [**mtcmedia/multi-buy-discounts**](https://bitbucket.org/mtcmedia/packages-multi-buy-discounts/) - advanded discount system for creating multi-buy or custom discounts (member specific/product specific)
* [**mtcmedia/events**](https://bitbucket.org/mtcmedia/events/) - module that allows creating events with tickets that can be purchased
* [**mtcmedia/refunds**](https://bitbucket.org/mtcmedia/refunds/) - module to allow money refunding on orders (via gateways that support this feature)
* [**mtcmedia/returns**](https://bitbucket.org/mtcmedia/returns/) - module for handling product return requests on orders


Additionally following **Payment Providers** are available to install:

* [**Bank Transfer**](https://bitbucket.org/mtcmedia/packages-bank-transfer-payments/) - `mtcmedia/bank-transfer-payments` - dummy gateway that allows processing order where users make payments off-site
* [**Cheque Payments**](https://bitbucket.org/mtcmedia/packages-cheque-payments/) - `mtcmedia/cheque-payments` - dummy gateway that allows processing order where users make payments off-site
* [**Klarna Payments**](https://bitbucket.org/mtcmedia/klarna-payments/) - `mtcmedia/klarna-payments` - take payments with [Klarna](https://www.klarna.com/international/)
* [**On Collection Payments**](https://bitbucket.org/mtcmedia/packages-on-collection-payments/) - `mtcmedia/on-collection-payments` - dummy payment method for paying in store when user is collecting order
* [**PayPal Express Checkout Payments**](https://bitbucket.org/mtcmedia/packages-paypal-express-checkout-payments/) - `mtcmedia/paypal-express-checkout-payments` - older version of PayPal payments. Uses payment from basket page instead of checkout.
* [**Realex Payments**](https://bitbucket.org/mtcmedia/pacakges-realex-payments/) - `mtcmedia/realex-payments` - known also as [Global Payments](https://www.globalpayments.com/en-gb)
* [**Sagepay/Opayo Form Payments**](https://bitbucket.org/mtcmedia/sagepay-form-payments/) - `mtcmedia/sagepay-form-payments` - take payments with [SagePay a.k.a Opayo](https://www.opayo.co.uk/developers)
* [**Stripe Payments**](https://bitbucket.org/mtcmedia/packages-stripe-payments/) - `mtcmedia/stripe-payments` - take payments using [Stripe](https://stripe.com/docs)
* [**WorldPay Payments**](https://bitbucket.org/mtcmedia/worldpay-payments/) - `mtcmedia/worldpay-payments` - take payments using [WorldPay](https://online.worldpay.com/)

## System Concept

This section describes key functionality concept of the shop system. Detailed functionality details should be located within each package

Ecommerce system is built to handle the purchasing of products or other Purchasable objects (event tickets etc.).
Purchase flow normally starts from finding product on site (currently not managed by this package) and starting purchase flow 
by adding product to _basket_. Basket does support having various quantities of various products in it - it is not restricted to 
buy only one product at the time so customer can navigate on the site to different products. To be added to basket a data model 
needs to implement **Purchasable** interface as it defines all characteristics required by the basket system.

On basket page (normally `/basket`) user can see their basket, adjust quantities, see estimated total and apply discount coupons.
**Coupons** are text based codes that offer specific discounts to purchase - these can be both _amount_ and _percentage_ and can 
apply to both applicable basket items or all of the basket (i.e. coupon can be applicable to only some basket products).
Coupons can also offer free delivery to primary region (UK) or worldwide, however this is managed through shipping rate modifiers 
and will require a free delivery rate to exist with the respective modifiers. Admin users have access to managing coupons.

Basket page does offer interface for quick-purchase options if there are gateways that support it (PayPal Express Checkout, Apple/Google Pay through Stripe).
If user uses quick-purchase journey, customer details are pulled from the payment provider and customer can complete purchase
without entering their details manually. Alternatively customer proceeds to checkout page.

**Checkout** page does require user to fill out their purchase details in full:

* customer details (email/phone/delivery message)
* type of delivery (shipping or collection)
* shipping address (if shipping delivery) or collection address (if collection delivery)
* shipping method/cost selection (if shipping delivery) to customers address 
* billing details (usually pre-filled from shipping details)
* payment details (via available payment gateways).

Payment gateways will appear only when all sections of the basket are validated and have all the required information.  
When basket fully validates it will attempt creating a payable object (order) from basket. During generation of Order system also
generates one or more Invoices. When taking payment, it is logged against Invoice not order therefore allowing for flexibility of 
part-payments. By default system uses only one invoice per purchase, but there is an alternate Invoice Factory class to allow 
creating two invoices based on in/out of stock items. In the case of necessity it is possible to set up custom amount of invoices 
for order.

Payment gateway will take payment in a secure fashion and ensure order payment is confirmed (aside from dummy gateways) before marking invoice as processed.
When invoice is processed as paid it triggers event to also check if order is fully paid. When order is fully paid it triggers
OrderPaid event that can be used for events like notify users about order, deduct stock from stock system etc.

> (!) We do not implement payment gateways that require PCI-DSS compliance. If gateway requires payment card details (number/cvc) to be processed on server (php)
> this payment provider is not supported and should not be implemented

If order payment was confirmed successfully customer is landed on payment success page. Alternatively customer is either presented with error
on basket page or shown a payment failed page. Customers can quickly perform an account setup from payment success page if
they do not have an account. Sales tracking is registered on payment success page (first load only) if it has been set up for site. 

Customers do have access to setting up accounts and logging into their accounts via `/members` url. Members area provide
quick access to previous orders as well as provides with the benefit of storing address details making purchases easier as details
will be pre-filled in basket.

Admin users have access to handle order post-processing as well as configuring some elements of ecommerce purchase system.

Admin area does have sections for setting up **Collection Points** - locations that are available for customer to use for order pick-up.
It also allows managing **Shipping** via region based rate setup. Shipping rates are set up for specific regions (individual countries,
country groups or postal zones inside UK). Each region will then specify their own rates. On basket these rates are filtered based of customer
shipping country/postal zone. Shipping rates can have restrictions for price or weight ranges (i.e. rate available when basket value is over £100)
and can have modifiers applied to them. Rate modifier system allows restricting rates to only when certain modifier is matched (e.g. only when 
free delivery coupon was applied to order).

Additionally admin area allows handling Order processing flow. Admin user has access to Order Statuses which allow defining the state of the order.
Switching to an order status may trigger an order email and Order Status management allows controlling whether an email should be sent and what
descriptive content on it should be used.

Order Management allows users to view and process orders. Simplest action that can be done on order is changing its status.
If site has shipment creation enabled (`orders.shipment_creation` config) and courier integration linked (`courier.enabled` 
config and `COURIER_SERVICE_API_TOKEN` env value) up with [mtc delivery service](http://delivery.mtcassets.com/admin) shipping label generation 
can be done via creating order shipments. Without shipment creation it is possible to simply enter tracking codes for orders manually.

## Change Log

v0.1.0 - 2019-11-11 - Initial release on v1.x branch

v0.1.1 - 2019-11-21 - Shipping installer change 

v1.0.0 - 2020-04-06 - Update to v1.x with change of installation process and members area being added to packages

v1.1.0 - 2021-03-15 - Added Taxonomies

v1.2.0 - 2021-06-02 - Updated packages to support php8.x

v1.3.0 - 2021-11-17 - Added PayPal payments as default payment provider
