<?php

namespace Mtc\ShopDashboardStats\Providers;

use Illuminate\Support\ServiceProvider;

class PackageServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
       $this->loadRoutesFrom(__DIR__.'/../../routes/web.php');
       $this->loadViewsFrom(__DIR__.'/../../resources/views', 'mtc-shop-dashboard-stats');

        $this->publishes([
            __DIR__.'/../../config/mtc-shop-dashboard-stats.php' => config_path('mtc-shop-dashboard-stats.php'),
        ], 'mtc-shop-dashboard-stats:config');
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../../config/mtc-shop-dashboard-stats.php', 'mtc-shop-dashboard-stats'
        );

        $this->app->register(EventServiceProvider::class);
    }
}
