<?php

namespace Mtc\ShopDashboardStats;

use Illuminate\Support\Facades\App;
use Mtc\AnalyticsStats\Stats;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Orders\Item;

class OrderStats
{
    /**
     * Total sales value in period
     *
     * @param $start_date
     * @param $end_date
     * @return mixed
     */
    public static function totalSales($start_date, $end_date)
    {
        return App::make(OrderContract::class)
            ->where('paid_at', '>=', $start_date)
            ->where('paid_at', '<=', $end_date)
            ->sum('cost_total');
    }

    /**
     * Order count value in period
     *
     * @param $start_date
     * @param $end_date
     * @return mixed
     */
    public static function orderCount($start_date, $end_date)
    {
        return App::make(OrderContract::class)
            ->where('paid_at', '>=', $start_date)
            ->where('paid_at', '<=', $end_date)
            ->count();
    }

    /**
     * @param $start_date
     * @param $end_date
     * @return mixed
     */
    public static function averageOrderValue($start_date, $end_date)
    {
        return App::make(OrderContract::class)
            ->where('paid_at', '>=', $start_date)
            ->where('paid_at', '<=', $end_date)
            ->avg('cost_total');

    }

    /**
     * @param $start_date
     * @param $end_date
     * @return mixed
     */
    public static function itemCount($start_date, $end_date)
    {
        return Item::query()
            ->wherehas('order', function ($order_query) use ($start_date, $end_date) {
                $order_query
                    ->where('paid_at', '>=', $start_date)
                    ->where('paid_at', '<=', $end_date);
            })
            ->sum('quantity');
    }


    /**
     * @param $start_date
     * @param $end_date
     * @return \Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Support\Collection
     */
    public static function mostItemsSold($start_date, $end_date, $amount)
    {
        return Item::query()
            ->wherehas('order', function ($order_query) use ($start_date, $end_date) {
                $order_query
                    ->where('paid_at', '>=', $start_date)
                    ->where('paid_at', '<=', $end_date);
            })
            ->get()
            ->groupBy(function ($item) {
                return $item->name ?? 'Removed product';
            })
            ->map(function ($item_group) {
                return $item_group->sum('quantity');
            })
            ->sortByDesc(function ($amount) {
                return $amount;
            })
            ->take($amount);
    }

    public static function analytics()
    {
        return new Stats(config('mtc-shop-dashboard-stats.analytics_view_id'));
    }
}
