<?php

namespace Mtc\ShippingManager;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Mtc\Money\HasPrices;

/**
 * Class ShippingZoneRate
 *
 * @author  Haroldas Latonas
 */
class CollectionPoint extends Model
{
    use HasPrices;

    /**
     * @var string $table
     */
    protected $table = 'shipping_collection_points';

    /**
     * @var array $fillable
     */
    protected $fillable = [
        'name',
        'address1',
        'address2',
        'city',
        'county',
        'postcode',
        'state',
        'country',
        'notes',
    ];

    protected static function boot()
    {
        parent::boot();

        self::saved(function () {
            Cache::forget('collection-locations');
        });
    }

    /**
     * @return mixed
     * @throws \Exception
     */
    public function getPriceAttribute()
    {
        return $this->loadPriceFromValue('shipping_manager.shipping_types.collection.cost', 'price');
    }

    /**
     * @return mixed
     */
    public function getNameAttribute()
    {
        return $this->attributes['name'];
    }
}
