<?php

namespace Mtc\ShippingManager\Listeners;

use Mtc\ShippingManager\Discount\Discount;
use Mtc\ShippingManager\Http\Events\SetDeliveryForBasket;

/**
 * Class UpdateOrderShipmentInfo
 *
 * Update order with delivery method information
 *
 * @package Mtc\ShippingManager
 */
class SetBasketDiscount
{
    /**
     * Set the delivery name for order when creating it
     *
     * @param NewOrderEvent $event
     */
    public static function handle(\Mtc\ShippingManager\Events\SetDeliveryForBasket $event)
    {
        if (!config('shipping_manager.discount')) {
            return;
        }

        $request = $event->getRequest();

        //Remove all delivery discounts
        $event->getBasket()
            ->discounts()
            ->where('discount_type', config('shipping_manager.discount_relation_name'))
            ->delete();

        //Get shipping rate
        $rate_discount = Discount::query()
            ->find($request->input('method_id'));

        //Check if rate have discount
        if ($rate_discount->discount) {
            //Check if rate discount is available for basket and for basket items
            if ($rate_discount->availableForBasket($event->getBasket()) && $rate_discount->availableForItems($event->getBasket()->items)) {
                $event->getBasketRepository()->addDiscount($rate_discount->id, config('shipping_manager.discount_relation_name'));
            }
        }
    }
}
