<?php

namespace Mtc\ShippingManager;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Cache;
use Mtc\Basket\Contracts\BasketRepositoryInterface;

/**
 * Class Delivery
 *
 * @package Mtc\ShippingManager
 */
class Shipping
{

    /**
     * Add estimated shipping cost based on basket value
     */
    public function estimateShippingCost(BasketRepositoryInterface $basket)
    {
        $type = config('shipping_manager.preemptive_shipping_type');
        return App::make(config("shipping_manager.shipping_types.{$type}.class"))->methodsForBasket($basket);
    }

    /**
     * @return Collection
     */
    public function enabledTypes()
    {
        return collect(config('shipping_manager.shipping_types', []))
            ->filter(function ($type) {
                return $type['enabled'] && App::make($type['class'])->hasMethods();
            })
            ->map(function ($data, $type) {
                return __("basket::basket.{$type}");
            });
    }

    /**
     * Find available collect locations
     *
     * @param BasketRepositoryInterface $basket
     * @return array
     */
    public function collectLocations(BasketRepositoryInterface $basket)
    {
        if (config('shipping_manager.shipping_types.collection.enabled', false) === false) {
            return [];
        }

        // This should be handled better over time
        return Cache::rememberForever('collection-locations', function () {
            return CollectionPoint::query()
                ->get();
        });
    }
}
