<?php

namespace Mtc\ShippingManager\Contracts;

use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\ShippingManager\TableRate;

/**
 * Interface DeliveryModifier
 *
 * @package Mtc\ShippingManager
 */
interface ShippingModifier
{
    /**
     * Retrieve the name
     *
     * @return string
     */
    public function getName();

    /**
     * Check whether the modifier is applicable to the rate
     *
     * @return void
     */
    public function isApplicable(BasketRepositoryInterface $basket, TableRate $rate);

    /**
     * Define whether this modifier MUST be matched for this rate to work
     *
     * @return bool
     */
    public function isMandatoryOnRate(): bool;

    /**
     * Define whether this modifier matching will discard other rates
     *
     * @return bool
     */
    public function willDiscardOtherRates(): bool;

    /**
     * Define whether this modifier matching will ignore the discard of other methods
     *
     * @return bool
     */
    public function isGloballyAvailable(): bool;
}
