<?php

namespace Mtc\ShippingManager\Contracts;

use Mtc\Orders\OrderShipment;

/**
 * Interface DeliveryCourierOrderMap
 *
 * @package Mtc\ShippingManager
 */
interface CourierShipmentMapContract
{
    /**
     * Mapping class needs to be able to map the order shipment to the format required by API
     *
     * @param OrderShipment $shipment
     */
    public function map($shipment): array;
}
