<?php

namespace Mtc\ShippingManager\Seeds;

use Mtc\Core\Models\Country;
use Mtc\ShippingManager\Zone;
use Illuminate\Database\Seeder;

/**
 * Class ShippingManagerSeeder
 * @package Mtc\ShippingManager\
 */
class ShippingManagerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->seedMenu();
        $this->seedZones();
    }

    /**
     * Seed Admin menu
     */
    public function seedMenu()
    {
        $shop_module_menu = \Mtc\Core\Admin\Menu::query()
            ->where('title', 'Shop')
            ->where('constant', 'SHOP_ENABLED')
            ->first();

        if ($shop_module_menu->id) {
            $shipping_manager_submenu = $this->getShippingManagerSubMenu();
            foreach ($shipping_manager_submenu as $sub_menu) {
                $shop_module_menu->children()->create($sub_menu);
            }
        }
    }

    /**
     * Seed zones
     */
    public function seedZones()
    {
        if (!$this->command->confirm('Do you want to seed default delivery regions?')) {
            return;
        }
        $zones = $this->getZones();;
        foreach ($zones as $zone) {
            $created_zone = Zone::query()
                ->create([
                    'name' => $zone['name'],
                    'disabled' => $zone['disabled'],
                    'parent_id' => $zone['parent_id'],
                    'type' => $zone['type'],
                ]);

            $created_zone->rates()->createMany($zone['rates']);
            $created_zone->countries()->sync($zone['countries']);
        }
    }

    /**
     * Get Data for Admin Menu entries (Shop submenu)
     *
     * @return array
     */
    protected function getShippingManagerSubMenu()
    {
        return [
            [
                'title' => 'Delivery Couriers',
                'path' => '/admin/shipping-manager/delivery-couriers/',
                'activePath' => 'admin/shipping-manager/delivery-couriers/',
                'constant' => 'DELIVERY_SERVICES',
                'icon' => null,
                'order' => 18,
            ],
            [
                'title' => 'Collect Locations',
                'path' => '/admin/shipping-manager/collect-locations/',
                'activePath' => 'admin/shipping-manager/collect-locations/',
                'constant' => 'DELIVERY_SERVICES',
                'icon' => null,
                'order' => 19,
            ],
            [
                'title' => 'Shipping Zones',
                'path' => '/admin/shipping-manager/zones/',
                'activePath' => 'admin/shipping-manager/zones/',
                'constant' => 'SHIPPING_MANAGER',
                'icon' => null,
                'order' => 20,
            ],
        ];
    }

    /**
     * Get Data for zones
     *
     * @return array
     */
    protected function getZones()
    {
        return [
            [
                'name' => 'UK',
                'disabled' => 0,
                'parent_id' => 0,
                'type' => 'country',
                'rates' => [
                    [
                        'name' => "UK",
                        'disabled' => 0,
                        'rate_type' => 'price',
                        'range_min' => 0,
                        'range_max' => 999999,
                        'rate' => 5,
                        'order' => 0,
                    ],
                    [
                        'name' => "Free",
                        'disabled' => 0,
                        'rate_type' => 'price',
                        'range_min' => 0,
                        'range_max' => 999999,
                        'rate' => 25,
                        'order' => 0,
                        'modifiers' => [
                            'admin-user'
                        ]
                    ]
                ],
                'countries' => Country::query()
                    ->where('code', '=', 'GB')
                    ->get()
                    ->pluck('id')
            ],
            [
                'name' => 'Europe',
                'disabled' => 0,
                'parent_id' => 0,
                'type' => 'country',
                'rates' => [
                    [
                        'name' => "Europe",
                        'disabled' => 0,
                        'rate_type' => 'price',
                        'range_min' => 0,
                        'range_max' => 999999,
                        'rate' => 15,
                        'order' => 0,
                    ],
                    [
                        'name' => "Free",
                        'disabled' => 0,
                        'rate_type' => 'price',
                        'range_min' => 0,
                        'range_max' => 999999,
                        'rate' => 25,
                        'order' => 0,
                        'modifiers' => [
                            'admin-user'
                        ]
                    ]
                ],
                'countries' => Country::query()
                    ->where('continent_code', '=', 'EU')
                    ->where('code', '!=', 'GB')
                    ->get()
                    ->pluck('id')
            ],
            [
                'name' => 'Worldwide',
                'disabled' => 0,
                'parent_id' => 0,
                'type' => 'country',
                'rates' => [
                    [
                        'name' => "Worldwide Shipping",
                        'disabled' => 0,
                        'rate_type' => 'price',
                        'range_min' => 0,
                        'range_max' => 999999,
                        'rate' => 25,
                        'order' => 0,
                    ],
                    [
                        'name' => "Free",
                        'disabled' => 0,
                        'rate_type' => 'price',
                        'range_min' => 0,
                        'range_max' => 999999,
                        'rate' => 25,
                        'order' => 0,
                        'modifiers' => [
                            'admin-user'
                        ]
                    ]
                ],
                'countries' => Country::query()
                    ->where('continent_code', '!=', 'EU')
                    ->get()
                    ->pluck('id')
            ],
        ];
    }

}
