<?php

namespace Mtc\ShippingManager\Listeners;

use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Basket\Events\MutateBasketAjaxResponse;
use Mtc\ShippingManager\Facades\DeliveryMethod;

/**
 * Class UpdateOrderShipmentInfo
 *
 * Update order with delivery method information
 *
 * @package Mtc\ShippingManager
 */
class ProvideDeliveryMethodsToBasket
{
    /**
     * Set the delivery name for order when creating it
     *
     * @param MutateBasketAjaxResponse $event
     */
    public static function handle(MutateBasketAjaxResponse $event)
    {
        return [
            'delivery-options' => DeliveryMethod::methodsForBasket(App::make(BasketRepositoryInterface::class))
        ];
    }
}
