<?php

namespace Mtc\ShippingManager\Facades;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Facade;
use Mtc\Orders\OrderShipment;
use Mtc\ShippingManager\Courier\CourierService;

/**
 * Class Courier
 *
 * @package Mtc\ShippingManager
 * @see CourierService
 * @method static send(OrderShipment $order)
 * @method static getServices()
 * @method static processWebHook(Request $request)
 *
 */
class Courier extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'courier';
    }
}
