<?php

namespace Mtc\ShippingManager\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\App;
use Illuminate\Support\ServiceProvider;
use Mtc\ShippingManager\Contracts\CourierShipmentMapContract;
use Mtc\ShippingManager\Contracts\DeliveryCourierServiceContract;

/**
 * Class CourierServiceProvider
 *
 * @package Mtc\ShippingManager
 */
class CourierServiceProvider extends ServiceProvider
{

    /**
     * Register plugin service provider
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/courier.php', 'courier');
        if (config('courier.enabled', false) === false) {
            return;
        }

        App::bind(CourierShipmentMapContract::class, function () {
            return App::make(config('courier.shipment_map_to_courier'));
        });

        App::bind(DeliveryCourierServiceContract::class, function () {
            return App::make(config('courier.courier_service'));
        });

        App::bind('courier', function () {
            return App::make(DeliveryCourierServiceContract::class);
        });
    }

    /**
     * Boot provider
     */
    public function boot()
    {
        if (config('courier.enabled', false) === false) {
            return;
        }

        Route::middleware('api')->group(dirname(__DIR__, 2) . '/routes/api.php');
    }
}
