<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Global enable toggle
    |--------------------------------------------------------------------------
    |
    | Disabling this will not bootstrap anything for the service
    |
    */

    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Is integration live
    |--------------------------------------------------------------------------
    |
    | Toggle for setting integration live
    |
    */
    'live' => env('COURIER_SERVICE_LIVE', false),


    /*
    |--------------------------------------------------------------------------
    | API token
    |--------------------------------------------------------------------------
    |
    | Authentication token - provided by the courier service, used for sending requests
    |
    */
    'api_token' => env('COURIER_SERVICE_API_TOKEN', ''),

    /*
    |--------------------------------------------------------------------------
    | Class bindings
    |--------------------------------------------------------------------------
    |
    | Service class defines the courier service used by the application
    | Shipment map is the mapping process from our database to API acceptable format
    |
    */

    'courier_service' => \Mtc\ShippingManager\Courier\CourierService::class,
    'shipment_map_to_courier' => \Mtc\ShippingManager\Courier\ShipmentMap::class,

    /*
    |--------------------------------------------------------------------------
    | Endpoints
    |--------------------------------------------------------------------------
    |
    | Definition of API endpoints.
    |
    */
    'delivery_service_url' =>  env('COURIER_SERVICE_URL', 'http://delivery.mtcassets.com/'),
    'delivery_service_test_url' =>  env('COURIER_SERVICE_URL', 'http://delivery.mtcdevserver3.com/'),
];
