<?php

namespace Mtc\ShippingManager\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Mtc\Basket\Events\MutateBasketAjaxResponse;
use Mtc\ShippingManager\Listeners\RemoveShippingMethodWhenTypeSwitched;
use Mtc\ShippingManager\Listeners\SetBasketDiscount;
use Mtc\ShippingManager\Events\SetDeliveryForBasket;
use Mtc\ShippingManager\Listeners\ProvideDeliveryMethodsToBasket;
use Mtc\ShippingManager\Listeners\UpdateOrderShipmentInfo;
use Mtc\Shop\Events\NewOrderEvent;
use Illuminate\Support\Facades\Event;

/**
 * Class ShippingServiceProvider
 *
 * @package Mtc\ShippingManager
 */
class ShippingEventServiceProvider extends EventServiceProvider
{
    /**
     * Events and their listeners
     *
     * @var array
     */
    protected $listen = [
        MutateBasketAjaxResponse::class => [
            ProvideDeliveryMethodsToBasket::class
        ],
        NewOrderEvent::class => [
            UpdateOrderShipmentInfo::class
        ],
        'eloquent.saved: Mtc\\Basket\\Basket' => [
            RemoveShippingMethodWhenTypeSwitched::class,
        ]
    ];

    /**
     * Boot plugin service provider
     */
    public function boot()
    {
        //Check if plugin enabled (Admin Settings)
        if (config('shipping_manager.enabled') !== true) {
            return;
        }

        parent::boot();

        if (config('shipping_manager.discount')) {
            Event::listen(SetDeliveryForBasket::class, SetBasketDiscount::class);
        }

    }

}
