<?php

namespace Mtc\ShippingManager\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\ShippingManager\CourierCollectLocation;

/**
 * Class CollectLocationController
 * @package Mtc\Plugins\ShippingManager\Classes\Http\Controllers\Admin\DeliveryCourier
 */
class CollectLocationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function index() {

        $self_action = url('/admin/shipping-manager/collect-locations');

        $collect_locations = CourierCollectLocation::all();

        $this->page_meta['page_name'] = 'Collect Locations';

        return $this->twig->render('ShippingManager/admin/collect_locations/list.twig', [
            'page_meta' => $this->page_meta,
            'self_action' => $self_action,
            'collect_locations' => $collect_locations,
            'selected_tab_nav' => 'list',
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function create(Request $request)
    {
        $store_action = url('/admin/shipping-manager/collect-locations');

        $this->page_meta['page_name'] = 'Add New Collect Location';

        return $this->twig->render('ShippingManager/admin/collect_locations/edit.twig', [
            'page_meta' => $this->page_meta,
            'selected_tab_nav' => 'add',
            'store_action' => $store_action
        ]);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param $collect_location_id
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function edit(Request $request, $collect_location_id)
    {
        $update_action = dirname($request->getPathInfo());

        $collect_location = CourierCollectLocation::find($collect_location_id);

        $this->page_meta['page_name'] = 'Edit Collect Location';

        return $this->twig->render('ShippingManager/admin/collect_locations/edit.twig', [
            'page_meta' => $this->page_meta,
            'collect_location' => $collect_location,
            'update_action' => $update_action
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param $collect_location_id
     * @return mixed
     */
    public function update(Request $request, $collect_location_id)
    {
        $validated = $this->validate($request, [
            'contact_name' => 'required',
            'contact_phone' => 'required',
            'contact_email' => 'required',
            'organisation' => 'required',
            'address1' => 'required',
            'city' => 'required',
            'country' => 'required',
            'postcode' => 'required',
        ]);

        $collect_location = CourierCollectLocation::query()->findOrFail($collect_location_id);
        $collect_location->fill($request->all())->save();

        session()->flash('success', 'Collect Location updated');
        return redirect()->back();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return mixed
     */
    public function store(Request $request)
    {
        $validated = $this->validate($request, [
            'contact_name' => 'required',
            'contact_phone' => 'required',
            'contact_email' => 'required',
            'organisation' => 'required',
            'address1' => 'required',
            'city' => 'required',
            'country' => 'required',
            'postcode' => 'required',
        ]);

        $collect_location = CourierCollectLocation::query()
            ->create([
                'contact_name' => $request->input('contact_name'),
                'contact_phone' => $request->input('contact_phone'),
                'contact_email' => $request->input('contact_email'),
                'organisation' => $request->input('organisation'),
                'address1' => $request->input('address1'),
                'address2' => $request->input('address2'),
                'city' => $request->input('city'),
                'country' => $request->input('country'),
                'postcode' => $request->input('postcode'),
                'county' => $request->input('county'),
            ]);

        session()->flash('success', 'Collect Location created');
        return redirect('/admin/shipping-manager/collect-locations/'. $collect_location->id . '/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param $collect_location_id
     * @return mixed
     */
    public function destroy($collect_location_id)
    {
        $collect_location = CourierCollectLocation::query()->findOrFail($collect_location_id);
        $collect_location->delete();
        session()->flash('success', 'Courier Location deleted');
        return redirect()->back();
    }

}
