<?php

namespace Mtc\ShippingManager\Contracts;

use Illuminate\Http\Request;
use Mtc\Orders\OrderShipment;

/**
 * Interface DeliveryCourierOrderMap
 *
 * @package Mtc\ShippingManager
 */
interface DeliveryCourierServiceContract
{
    /**
     * Send order to courier through api
     *
     * @param OrderShipment $shipment
     * @return bool
     */
    public function send($shipment): bool;

    /**
     * Get the list of available services
     *
     * @return array
     */
    public function getServices(): array;

    /**
     * Process incoming web-hook
     *
     * @return bool whether request was accepted
     */
    public function processWebHook(Request $request): bool;
}
